
/**
 ******************************************************************************
 *
 * @file        MG32_BLDC_API.h
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/05/28
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#ifndef _MG32_BLDC_API_H_
#define _MG32_BLDC_API_H_

#include "MG32.h"
#include "MG32_TM_MID.h"

/* Wizard menu ---------------------------------------------------------------*/
//<<< Use Configuration Wizard in Context Menu >>>

// <h> MG32F02A032 MCU parameter (48MHz)
// </h>
#define SYSCLK          48000000


// <h> motor parameter
//  <o0> number poles (pairs) <0-20>
//  <o1> Max desired speed <0-10000>
//  <o2> Min desired speed <150-10000>
//  <o3> offset of synchrounization Hall signal <0-50>
// </h>

#define NUM_POLES       2           // motor poles
#define MAX_RPM         3000        // max desired speed
#define MIN_RPM         950         // lowest-threshold speed
#define IDXOffset       0

// <h> motor startup parameter
//  <o0> initiail duty <1-1024>
//  <o2> dead-time setting <24-255>
// </h>
#define INIT_DUTY       280
#define DeadTime_Set    26


// <h> PI-controller parameter
//  <o0> proportion item - Kp <0-50>
//  <o1> integral item - Ki <0-20>
//  <o2> calculate period <0-500>
//      <i> unit : ms
//  <o3> Kp statutaton <1-500>
//  <o4> Ki statutaton <1-500>
// </h>
#define KPINIT          20          // Kp initial value
#define KIINIT          3           // Ki initial value
#define PID_peroid      150
#define KpStatution     192
#define KiStatution     96

//<<< end of configuration section >>>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
//-----------------------------------------------------------------------------
// preprocessor calculated values
#define SineSteps       192
#define T_MAX_RPM       (60 * (SYSCLK / MAX_RPM / 6 / NUM_POLES / 32))
#define T_MIN_RPM       (60 * (SYSCLK / MIN_RPM / 6 / NUM_POLES / 32))
#define CalRPMTBase     ((SYSCLK / SineSteps / NUM_POLES) * 60)

/* Private macro -------------------------------------------------------------*/
/**
 *******************************************************************************
 * @brief       Get Hall position.
 * @param[in]   None
 * @return      Return Hall Position (16bit)
 *******************************************************************************
 */
#define API_BLDC_GET_HALL()     ((GPIO_ReadPort(GPIOD) & 0x0380) >> 3)

/**
 *******************************************************************************
 * @brief       Convert Motor's speed to RPM
 * @param[in]   None.
 * @return      The motor speed of RPM
 *******************************************************************************
 */
#define ConvertMotorSpeed()     ((CalRPMTBase) / hMotor.MotorSpeed)

/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/**
 * @name    Function announce
 * @brief   Time base initial/Deinitial
 */
///@{
void API_BLDC_Init(void);
void API_BLDC_UpdateTable(void);

MID_StatusTypeDef API_BLDC_IDX_Initial(void);
void API_BLDC_Startup(uint16_t sDutyControl);
void API_BLDC_Running_Init(void);
void API_BLDC_SynchronizationUVW(void);
void API_BLDC_STOP(void);
void API_BLDC_ReverseRotating (void);


void API_BLDC_STARTUP_CH0_PWM(uint16_t sDutyControl);
void API_BLDC_STARTUP_CH1_PWM(uint16_t sDutyControl);
void API_BLDC_STARTUP_CH2_PWM(uint16_t sDutyControl);

void API_BLDC_STARTUP_CH0_DISABLE(void);
void API_BLDC_STARTUP_CH1_DISABLE(void);
void API_BLDC_STARTUP_CH2_DISABLE(void);

void API_BLDC_STARTUP_CH0_TOP0_BOTTOM1(void);
void API_BLDC_STARTUP_CH1_TOP0_BOTTOM1(void);
void API_BLDC_STARTUP_CH2_TOP0_BOTTOM1(void);

void API_BLDC_STARTUP_CHx_DISABLE(void);
///@}

/**
 * @name    Function announce
 * @brief   PI controller
 */
///@{
int32_t saturate(int32_t i, int32_t l);
void PI_Cal_KpKi_routine(void);
void PI_Calculate(void);
///@}

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

#endif

